/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.Utils;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlockTile;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.client.asset_generators.textures.PaletteColor;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Respriter;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.items.WoodBasedBlockItem;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.mehvahdjukaar.selene.resourcepack.BlockTypeResTransformer;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.DynamicLanguageManager;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.resources.TagBuilder;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.HedgeBlock;
import vazkii.quark.content.building.block.VariantBookshelfBlock;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.module.HedgesModule;
import vazkii.quark.content.building.module.VariantBookshelvesModule;
import vazkii.quark.content.building.module.VerticalPlanksModule;
import vazkii.quark.content.building.module.WoodenPostsModule;

@Deprecated
public class LegacyQM
extends CompatModule {
    public static final String POST_NAME = "post";
    public static final Map<WoodType, Block> POSTS = new HashMap<WoodType, Block>();
    public static final Map<WoodType, Item> POST_ITEMS = new HashMap<WoodType, Item>();
    public static final String STRIPPED_POST_NAME = "stripped_post";
    public static final Map<WoodType, Block> STRIPPED_POSTS = new HashMap<WoodType, Block>();
    public static final Map<WoodType, Item> STRIPPED_POST_ITEMS = new HashMap<WoodType, Item>();
    public static final String BOOKSHELF_NAME = "bookshelf";
    public static final Map<WoodType, Block> BOOKSHELVES = new HashMap<WoodType, Block>();
    public static final Map<WoodType, Item> BOOKSHELF_ITEMS = new HashMap<WoodType, Item>();
    public static final String VERTICAL_PLANK_NAME = "vertical_planks";
    public static final Map<WoodType, Block> VERTICAL_PLANKS = new HashMap<WoodType, Block>();
    public static final Map<WoodType, Item> VERTICAL_PLANK_ITEMS = new HashMap<WoodType, Item>();
    public static final String HEDGE_NAME = "hedge";
    public static final Map<LeavesType, Block> HEDGES = new HashMap<LeavesType, Block>();
    public static final Map<LeavesType, Item> HEDGE_ITEMS = new HashMap<LeavesType, Item>();
    public static BlockEntityType<CompatChestBlockTile> COMPAT_CHEST_TILE = null;

    public LegacyQM(String modId) {
        super(modId);
    }

    @Override
    public String shortenedId() {
        return "q";
    }

    @Override
    public void registerWoodBlocks(IForgeRegistry<Block> registry, Collection<WoodType> woodTypes) {
        Map ARLModData;
        try {
            Field f = ObfuscationReflectionHelper.findField(RegistryHelper.class, (String)"modData");
            f.setAccessible(true);
            ARLModData = (Map)f.get(null);
        }
        catch (Exception e) {
            WoodGood.LOGGER.error("Failed to setup Wood Good Quark Module");
            return;
        }
        this.addChildToOak(this.shortenedId() + "/post", "oak_post");
        this.addChildToOak(this.shortenedId() + "/stripped_post", "stripped_oak_post");
        for (WoodType w : woodTypes) {
            Block fence = w.getBlockOfThis("fence");
            if (fence == null) continue;
            boolean nether = !w.canBurn();
            String name = w.getVariantId(POST_NAME, false);
            String strippedName = this.makeBlockId((BlockType)w, STRIPPED_POST_NAME);
            if (w.isVanilla() || this.isEntryAlreadyRegistered(name, (BlockType)w, registry)) continue;
            QuarkModule module = ModuleLoader.INSTANCE.getModuleInstance(WoodenPostsModule.class);
            String prefix = this.shortenedId() + "/" + w.getNamespace() + "/";
            WoodPostBlock post = new WoodPostBlock(module, fence, prefix, nether);
            POSTS.put(w, (Block)post);
            registry.register((IForgeRegistryEntry)post);
            w.addChild(this.shortenedId() + "/post", (ItemLike)post);
            if (w.getTypeName().contains("stripped")) continue;
            WoodPostBlock stripped = new WoodPostBlock(module, fence, prefix + "stripped_", nether);
            STRIPPED_POSTS.put(w, (Block)stripped);
            registry.register((IForgeRegistryEntry)stripped);
            ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_STRIP, (Block)post, (Block)stripped);
            w.addChild(this.shortenedId() + "/stripped_post", (ItemLike)stripped);
        }
        WoodType.OAK_WOOD_TYPE.addChild(this.shortenedId() + "/bookshelf", (ItemLike)Blocks.f_50078_);
        ((WoodType)WoodTypeRegistry.WOOD_TYPES.get(new ResourceLocation("acacia"))).addChild(this.shortenedId() + "/bookshelf", (ItemLike)ForgeRegistries.BLOCKS.getValue(this.modRes("acacia_bookshelf")));
        for (WoodType w : woodTypes) {
            boolean nether = !w.canBurn();
            String name = w.getVariantId(BOOKSHELF_NAME, false);
            if (w.isVanilla() || this.isEntryAlreadyRegistered(name, (BlockType)w, registry)) continue;
            QuarkModule module = ModuleLoader.INSTANCE.getModuleInstance(VariantBookshelvesModule.class);
            String prefix = this.shortenedId() + "/" + w.getAppendableId();
            VariantBookshelfBlock bookshelf = new VariantBookshelfBlock(prefix, module, nether);
            BOOKSHELVES.put(w, (Block)bookshelf);
            registry.register((IForgeRegistryEntry)bookshelf);
            w.addChild(this.shortenedId() + "/bookshelf", (ItemLike)bookshelf);
        }
        this.addChildToOak(this.shortenedId() + "/vertical_planks", "vertical_oak_planks");
        for (WoodType w : woodTypes) {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            if (w.isVanilla() || this.isEntryAlreadyRegistered(name, (BlockType)w, registry)) continue;
            QuarkModule module = ModuleLoader.INSTANCE.getModuleInstance(VerticalPlanksModule.class);
            QuarkBlock block = new QuarkBlock(name, module, CreativeModeTab.f_40749_, WoodGood.copySafe((BlockBehaviour)w.planks));
            VERTICAL_PLANKS.put(w, (Block)block);
            registry.register((IForgeRegistryEntry)block);
            w.addChild(this.shortenedId() + "/vertical_planks", (ItemLike)block);
        }
        ARLModData.remove("everycomp");
    }

    @Override
    public void registerLeavesBlocks(IForgeRegistry<Block> registry, Collection<LeavesType> leavesTypes) {
        Field regName;
        Map ARLModData;
        try {
            Field f = ObfuscationReflectionHelper.findField(RegistryHelper.class, (String)"modData");
            f.setAccessible(true);
            ARLModData = (Map)f.get(null);
            regName = ObfuscationReflectionHelper.findField(ForgeRegistryEntry.class, (String)"registryName");
            regName.setAccessible(true);
        }
        catch (Exception e) {
            WoodGood.LOGGER.error("Failed to setup Wood Good Quark Module");
            return;
        }
        LeavesType.OAK_LEAVES_TYPE.addChild(this.shortenedId() + "/hedge", (ItemLike)ForgeRegistries.BLOCKS.getValue(this.modRes("oak_hedge")));
        for (LeavesType l : leavesTypes) {
            Block fence;
            String name = this.makeBlockId((BlockType)l, HEDGE_NAME);
            if (l.isVanilla() || this.isEntryAlreadyRegistered(name, (BlockType)l, registry) || l.woodType == null || (fence = l.woodType.getBlockOfThis("fence")) == null) continue;
            QuarkModule module = ModuleLoader.INSTANCE.getModuleInstance(HedgesModule.class);
            HedgeBlock block = new HedgeBlock(module, fence, l.leaves);
            try {
                regName.set(block, WoodGood.res(name));
                HEDGES.put(l, (Block)block);
                registry.register((IForgeRegistryEntry)block);
                l.addChild(this.shortenedId() + "/hedge", (ItemLike)block);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(String.format("Failed to set registry name for %s hedge", l));
            }
        }
        ARLModData.remove("everycomp");
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        CreativeModeTab tab = WoodGood.MOD_TAB != null ? WoodGood.MOD_TAB : CreativeModeTab.f_40750_;
        POSTS.forEach((w, value) -> {
            CreativeModeTab t = EarlyConfigs.isTypeEnabled(w) ? tab : null;
            WoodBasedBlockItem i = new WoodBasedBlockItem(value, new Item.Properties().m_41491_(t), w);
            POST_ITEMS.put((WoodType)w, (Item)i);
            registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
        });
        STRIPPED_POSTS.forEach((w, value) -> {
            CreativeModeTab t = EarlyConfigs.isTypeEnabled(w) ? tab : null;
            WoodBasedBlockItem i = new WoodBasedBlockItem(value, new Item.Properties().m_41491_(t), w);
            STRIPPED_POST_ITEMS.put((WoodType)w, (Item)i);
            registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
        });
        BOOKSHELVES.forEach((w, value) -> {
            CreativeModeTab t = EarlyConfigs.isTypeEnabled(w) ? tab : null;
            WoodBasedBlockItem i = new WoodBasedBlockItem(value, new Item.Properties().m_41491_(t), w);
            BOOKSHELF_ITEMS.put((WoodType)w, (Item)i);
            registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
        });
        VERTICAL_PLANKS.forEach((w, value) -> {
            CreativeModeTab t = EarlyConfigs.isTypeEnabled(w) ? tab : null;
            WoodBasedBlockItem i = new WoodBasedBlockItem(value, new Item.Properties().m_41491_(t), w);
            VERTICAL_PLANK_ITEMS.put((WoodType)w, (Item)i);
            registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
        });
        HEDGES.forEach((leavesType, value) -> {
            CreativeModeTab t = EarlyConfigs.isTypeEnabled(leavesType) ? tab : null;
            WoodBasedBlockItem i = new WoodBasedBlockItem(value, new Item.Properties().m_41491_(t), 200);
            HEDGE_ITEMS.put((LeavesType)leavesType, (Item)i);
            registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
        });
    }

    @Override
    public void registerColors(ColorHandlerEvent.Item event) {
        HEDGES.forEach((l, h) -> {
            ItemColors colors = event.getItemColors();
            ItemStack leafStack = new ItemStack((ItemLike)l.leaves);
            colors.m_92689_((stack, tintIndex) -> colors.m_92676_(leafStack, tintIndex), new ItemLike[]{h.m_5456_()});
        });
    }

    @Override
    public void addStaticServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        DynamicDataPack pack = (DynamicDataPack)handler.dynamicPack;
        TagBuilder bookshelves = TagBuilder.of((TagKey)Tags.Items.BOOKSHELVES).addEntries(BOOKSHELVES.values());
        pack.addTag(bookshelves, Registry.f_122901_);
        pack.addTag(bookshelves, Registry.f_122904_);
        POSTS.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        STRIPPED_POSTS.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        TagBuilder posts = TagBuilder.of((ResourceLocation)this.modRes("posts")).addEntries(POSTS.values()).addEntries(STRIPPED_POSTS.values());
        pack.addTag(posts, Registry.f_122901_);
        VERTICAL_PLANKS.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        TagBuilder verticalPlanks = TagBuilder.of((TagKey)BlockTags.f_13090_).addEntries(VERTICAL_PLANKS.values());
        pack.addTag(verticalPlanks, Registry.f_122901_);
        HEDGES.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        TagBuilder hedges = TagBuilder.of((ResourceLocation)this.modRes("hedges")).addEntries(HEDGES.values());
        pack.addTag(hedges, Registry.f_122901_);
        pack.addTag(hedges, Registry.f_122904_);
        pack.addTag(TagBuilder.of((TagKey)BlockTags.f_144280_).addTag(posts).addTag(hedges).addTag(bookshelves), Registry.f_122901_);
    }

    @Override
    public void addStaticClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, POSTS, "oak_post", ResType.ITEM_MODELS.getPath(this.modRes("oak_post")), ResType.BLOCKSTATES.getPath(this.modRes("oak_post")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, POSTS, BlockTypeResTransformer.wood((String)this.modId, (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/oak_log", "log", s -> !s.contains("top")).IDReplaceBlock("oak_post"), ResType.BLOCK_MODELS.getPath(this.modRes("oak_post")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, STRIPPED_POSTS, "stripped_oak_post", ResType.ITEM_MODELS.getPath(this.modRes("stripped_oak_post")), ResType.BLOCKSTATES.getPath(this.modRes("stripped_oak_post")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, STRIPPED_POSTS, BlockTypeResTransformer.wood((String)this.modId, (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/stripped_oak_log", "stripped_log", s -> !s.contains("top")).IDReplaceBlock("stripped_oak_post"), ResType.BLOCK_MODELS.getPath(this.modRes("stripped_oak_post")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, HEDGES, "oak_hedge", ResType.ITEM_MODELS.getPath(this.modRes("oak_hedge")), ResType.BLOCKSTATES.getPath(this.modRes("oak_hedge")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, HEDGES, BlockTypeResTransformer.leaves((String)this.modId, (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/oak_log", l -> l.woodType.log, s -> !s.contains("top")).replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves").IDReplaceBlock("oak_hedge"), ResType.BLOCK_MODELS.getPath(this.modRes("oak_hedge_side")), ResType.BLOCK_MODELS.getPath(this.modRes("oak_hedge_post")), ResType.BLOCK_MODELS.getPath(this.modRes("oak_hedge_extend")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, BOOKSHELVES, "acacia_bookshelf", ResType.ITEM_MODELS.getPath(this.modRes("acacia_bookshelf")), ResType.BLOCKSTATES.getPath(this.modRes("acacia_bookshelf")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, BOOKSHELVES, BlockTypeResTransformer.wood((String)this.modId, (ResourceManager)manager).replaceSimpleBlock(this.modId, "acacia_bookshelf").replaceWithTextureFromChild("minecraft:block/acacia_planks", "planks").IDReplaceBlock("acacia_bookshelf"), ResType.BLOCK_MODELS.getPath(this.modRes("acacia_bookshelf")));
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, VERTICAL_PLANKS, BlockTypeResTransformer.wood((String)this.modId, (ResourceManager)manager).replaceSimpleBlock(this.modId, "vertical_oak_planks").replaceWithTextureFromChild("minecraft:block/oak_planks", "planks").IDReplaceBlock("vertical_oak_planks"), ResType.ITEM_MODELS.getPath(this.modRes("vertical_oak_planks")), ResType.BLOCKSTATES.getPath(this.modRes("vertical_oak_planks")), ResType.BLOCK_MODELS.getPath(this.modRes("vertical_oak_planks")));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        Utils.addLeavesRecipes(this.modId, manager, (DynamicDataPack)handler.dynamicPack, HEDGE_ITEMS, "building/crafting/oak_hedge");
        Utils.addBlocksRecipes(this.modId, manager, (DynamicDataPack)handler.dynamicPack, BOOKSHELF_ITEMS, "building/crafting/acacia_bookshelf", (WoodType)WoodTypeRegistry.WOOD_TYPES.get(new ResourceLocation("acacia")));
        Utils.addWoodRecipes(this.modId, manager, (DynamicDataPack)handler.dynamicPack, POST_ITEMS, "building/crafting/oak_post");
        Utils.addWoodRecipes(this.modId, manager, (DynamicDataPack)handler.dynamicPack, STRIPPED_POST_ITEMS, "building/crafting/stripped_oak_post");
        Utils.addWoodRecipes(this.modId, manager, (DynamicDataPack)handler.dynamicPack, VERTICAL_PLANK_ITEMS, "building/crafting/vertplanks/vertical_oak_planks");
        Utils.addBlockResources(this.modId, manager, handler.dynamicPack, BOOKSHELVES, "acacia_bookshelf", ResType.BLOCK_LOOT_TABLES.getPath(this.modRes("acacia_bookshelf")));
    }

    @Override
    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
        POSTS.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.everycomp.post", (IBlockType)w, (Block)v));
        STRIPPED_POSTS.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.everycomp.stripped_post", (IBlockType)w, (Block)v));
        HEDGES.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.everycomp.hedge", (IBlockType)w, (Block)v));
        BOOKSHELVES.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.everycomp.bookshelf", (IBlockType)w, (Block)v));
        VERTICAL_PLANKS.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.everycomp.vertical_planks", (IBlockType)w, (Block)v));
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        try (TextureImage main = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("block/acacia_bookshelf"));
             TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("block/acacia_bookshelf_m"));){
            Respriter respriter = Respriter.masked((TextureImage)main, (TextureImage)mask);
            BOOKSHELVES.forEach((wood, table) -> {
                String id = table.getRegistryName().m_135815_();
                try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                    List palette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    for (Palette p : palette) {
                        PaletteColor l0 = p.getDarkest();
                        p.increaseDown();
                        p.increaseDown();
                        p.increaseDown();
                        p.increaseDown();
                        p.remove(l0);
                    }
                    this.addWoodTexture((WoodType)wood, handler, manager, "block/" + id, () -> respriter.recolorWithAnimation(palette, plankTexture.getMetadata()));
                }
                catch (Exception ex) {
                    handler.getLogger().error("Failed to generate Bookshelf block texture for for {} : {}", table, (Object)ex);
                }
            });
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate any Bookshelf block texture : ", (Throwable)ex);
        }
    }
}

